#ifdef GL_ES
precision mediump float;

varying float specular;
varying float diffuse;
varying float location;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in float specular;
in float diffuse;
in float location;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform float cutoff;

void main()
{
    if(location > cutoff)
	discard;

#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif    
    fragColor = vec4((tColor.rgb * diffuse) + vec3(specular * tColor.a), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
